/***************************************************************************
 *   Copyright (C) 2011 by Jeremy Burton   *
 *   jburton@39net-w04   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BASEITEM_H
#define BASEITEM_H

#include <math.h>

#include "dom.h"

#define MOVE_HANDLE_SIZE 10
#define SIZE_HANDLE_SIZE 10
#define ANGLE_HANDLE_SIZE 6
#define ANGLE_HANDLE_EXTEND 20
#define ANCHORANGLE_HANDLE_SIZE 6

#define pi 3.1415926

#define mmtopt(n) ((n)/25.4*72)
#define DegToRad(n) ((n)*(pi/180.0))
#define RadToDeg(n) ((n)/pi*180.0)

#define realtodev(n,r) ((n)/25.4*(r))
#define devtoreal(n,r) ((n)/(r)*25.4)

class CPoint : public QPoint
{
public:
  CPoint() : QPoint() {};
  CPoint(double x,double y) : QPoint((int)x,(int)y) {};
  CPoint &operator=(const QPoint &p);

  void rotate(const QPoint &, double);
  void rotate(double ang);
  void setPolar(const QPoint &ctr, int r, double ang);
  void setPolar(const QPoint &ctr, int rx, int ry, double ang);
  //void setPolar(const QPointF &ctr, int r, double ang);
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class CPointF : public QPointF
{
public:
  //using QPoint::QPoint;
  CPointF() : QPointF() {};
  CPointF(double x,double y) : QPointF(x,y) {};
  CPointF &operator=(const QPointF &p);

  void rotate(const QPointF &, double);
  void rotate(double ang);
  double r();
  void setPolar(const QPointF &ctr, double r, double ang);
  void setPolar(const QPointF &ctr, double rx, double ry, double ang);
  //void setPolar(const QPointF &ctr, int r, double ang);
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class baseprops
{
public:
    QPointF centre;
    bool stroke:1,fill:1,centrelock:1,sizelock:1,anglelock:1;
    QColor strokecolor;
    QColor fillcolor;
    qreal strokewidth;
    qreal angle;
};

class baseitem : public baseprops
{
public:
  enum EItemType {textitem1_type=0/*,circleitem_type*/,boxitem_type,polygonitem_type,radialitem_type,textitem2_type,ellipseitem_type,shapeitem_type};

  baseitem();
  virtual ~baseitem();
  virtual EItemType getType() = 0;
  virtual void paint(QPainter &painter, bool selected, double zoom) = 0;
  virtual void paint_handles(QPainter &painter, double zoom) = 0;
  virtual void output(QPainter &painter) = 0;
  virtual void toDom(QDomDocument &doc,QDomElement &parent) = 0;
  virtual void fromDom(QDomDocument &doc,QDomElement &element);
  virtual QString describe() = 0;
  virtual baseitem *dup() = 0;
  virtual double extent() = 0;

  void paint_handle_angle(QPainter &painter,const QPoint &ctr,int r);
  void paint_handle_angle2(QPainter &painter,const QPoint &ctr,int r);
  void paint_handle_move(QPainter &painter,const QPoint &ctr);
  void paint_handle_size(QPainter &painter,const QPoint &ctr,int rx,int ry,int angle);
  void paint_handle_size(QPainter &painter,const QPoint &rad);

  void toDom_content(QDomDocument &doc,QDomElement &element);

  CPoint angle_handle,move_handle;

  //Props
/*
    QPointF centre;
    bool stroke:1,fill:1,centrelock:1,sizelock:1,anglelock:1;
    QColor strokecolor;
    QColor fillcolor;
    qreal strokewidth;
    qreal angle;
*/
};

/*
class CTrans_base
{
public:
};
*/
#endif
