#include <lxpanel/plugin.h>

#include <stdio.h>
#include <string.h>
#include <stdbool.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <pthread.h>
#include <dirent.h>

#include <linux/netlink.h>
#include <linux/rtnetlink.h>

//#include "vpnmon2.h"

#define MYPROTO NETLINK_ROUTE
//#define MYMGRP RTMGRP_LINK|RTMGRP_IPV4_IFADDR|RTMGRP_IPV6_IFADDR
#define MYMGRP RTMGRP_LINK

#define PEERS_DIR "/etc/ppp/peers"
#define VPN_IF_NAME "ppp0"
//#define PON_CMD "/usr/bin/pon"
//#define POFF_CMD "/usr/bin/poff"
#define PON_CMD "pon"
#define POFF_CMD "poff"
//#define ICON_UP		GTK_STOCK_DIALOG_AUTHENTICATION
//#define ICON_DOWN	GTK_STOCK_DISCONNECT

static char *EXCLUDE_PEERS[] = {"provider",NULL};


/*
gcc -std=c99 -Wall `pkg-config --cflags gtk+-2.0 lxpanel` -shared -fPIC vpnmon2.c -o vpnmon.so `pkg-config --libs lxpanel`
cp vpnmon.so /usr/lib64/lxpanel/plugins/
cp vpnmon.so /usr/lib/arm-linux-gnueabihf/lxpanel/plugins/
*/

// internal to the plugin source, not used by the 'priv' variable
static int iInstanceCount = 0;

/* the plugin's id – an instance of this struct 
   is what will be assigned to 'priv' */
typedef struct 
{
    gint iMyId;
    //GtkWidget *mainw;
    //GtkWidget *pLabel;
    GtkWidget *pImage;
    GdkPixbuf *lock_pixbuf, *unlock_pixbuf;
    pthread_t monthreadid;
    
    int nls;
} VPNMon_data_t;

typedef struct 
{
    int vpn_up:1;
} VPNMon_static_t;

static VPNMon_static_t VPNMon_static;

/******************************************************************************/

static struct if_list_s
{
    struct if_item_s
    {
	int index;
	char name[IF_NAMESIZE];
	unsigned int up : 1;
    } *item;
    int count;
} ifs = {NULL,0};

static void ifs_free()
{
    if (ifs.item) free(ifs.item);
    ifs.item = NULL;
    ifs.count = 0;
}

static struct if_item_s *ifs_get_item(int ifindex)
{
    int i;
    
    for (i=0; i<ifs.count; i++)
	if (ifs.item[i].index == ifindex)
	    return &ifs.item[i];
    return NULL;
}

static struct if_item_s *ifs_set_item(int ifindex,int ifflags)
{
    struct if_item_s *p;
    char ifname[IF_NAMESIZE];
    
    p = ifs_get_item(ifindex);
    if (!p)
    {
	ifs.count++;
	ifs.item = (struct if_item_s *)realloc(ifs.item, sizeof(struct if_item_s)*ifs.count);
	p = &ifs.item[ifs.count-1];
	p->index = ifindex;
	p->name[0] = 0;
    }
    if (if_indextoname(ifindex,ifname))
	strncpy(p->name, ifname, IF_NAMESIZE);
    if (ifflags>=0)
	p->up = ifflags & IFF_UP;
    
    return p;
}

static void ifs_del_item(struct if_item_s *p /*int ifindex*/)
{
    //struct if_data_s *p;
    
    //p = get_if_data(ifindex);
    if (p && p>=ifs.item && p<(ifs.item-ifs.count))
    {
	memcpy(p,p+1,sizeof(struct if_item_s));
	ifs.count--;
	ifs.item = (struct if_item_s *)realloc(ifs.item, sizeof(struct if_item_s)*ifs.count);
    }
}

/******************************************************************************/

static struct peer_list_s
{
    struct peer_item_s
    {
	char name[32];
    } *item;
    int count;
} peers = {NULL,0};

static void peers_free()
{
    if (peers.item) free(peers.item);
    peers.item = NULL;
    peers.count = 0;
}

static void peers_clear()
{
    peers.count = 0;
}

static void peers_add(char *name)
{
    peers.count++;
    peers.item = (struct peer_item_s *)realloc(peers.item, sizeof(struct peer_item_s)*peers.count);
    struct peer_item_s *p = &peers.item[peers.count-1];
    strncpy(p->name,name,sizeof(p->name));
}

static int peers_compare(const void *a, const void *b)
{
    return strcmp(((struct peer_item_s *)a)->name, ((struct peer_item_s *)b)->name);
}

static void peers_load()
{
    DIR *dfd;
    struct dirent *dp;
    int i;
    
    if ((dfd = opendir(PEERS_DIR)) == NULL)
	return;
    
    peers_clear();
    
    while ((dp = readdir(dfd)) != NULL)
	if (dp->d_type == DT_REG)
	{
	    for (i=0; EXCLUDE_PEERS[i]; i++)
		if (strcmp(dp->d_name, EXCLUDE_PEERS[i])==0)
		    goto next_peer;
	    peers_add(dp->d_name);//printf("Peer: %s\n",dp->d_name);
next_peer:;
	}

    closedir(dfd);
    qsort(peers.item,peers.count,sizeof(struct peer_item_s),peers_compare);
}

/**********************************************************************************************************************/

static int open_netlink()
{
    int sock = socket(AF_NETLINK,SOCK_RAW,MYPROTO);
    struct sockaddr_nl addr;

    memset((void *)&addr, 0, sizeof(addr));

    if (sock<0)
        return sock;
    addr.nl_family = AF_NETLINK;
    addr.nl_pid = getpid();
    addr.nl_groups = MYMGRP;
    if (bind(sock,(struct sockaddr *)&addr,sizeof(addr))<0)
        return -1;
    return sock;
}

static void close_netlink(int nls)
{
    if (nls>=0)
	close(nls);
}

bool if_up(char *ifname)
{
    struct ifreq ifr;
    int sock = socket(PF_INET, SOCK_DGRAM, IPPROTO_IP);
    memset(&ifr, 0, sizeof(ifr));
    strcpy(ifr.ifr_name, ifname);
    if (ioctl(sock, SIOCGIFFLAGS, &ifr) < 0) {
            perror("SIOCGIFFLAGS");
    }
    close(sock);
// printf("if_up: %s\n",ifr.ifr_name);
// printf("\t%x,%x\n",ifr.ifr_flags,IFF_UP);
// printf("\t%d\n",!!(ifr.ifr_flags & IFF_UP));

    return !!(ifr.ifr_flags & IFF_UP);
}

/**********************************************************************************************************************/

void VPNMon_if_change(VPNMon_data_t *VPNMon_data, struct if_item_s *item)
{
    if (strcmp(item->name, VPN_IF_NAME)==0)
    {
       VPNMon_static.vpn_up = item->up;
    
//printf("if_change: name=%s, up=%d\n", data->name, data->up);
   
    //gtk_image_set_from_stock((GtkImage *)(VPNMon_data->pImage),VPNMon_static.vpn_up?ICON_UP:ICON_DOWN, GTK_ICON_SIZE_BUTTON);
	gtk_image_set_from_pixbuf((GtkImage *)(VPNMon_data->pImage), VPNMon_static.vpn_up?VPNMon_data->lock_pixbuf : VPNMon_data->unlock_pixbuf);
    }
}

/**********************************************************************************************************************/

static int VPNMon_msg_handler(VPNMon_data_t *VPNMon_data, struct sockaddr_nl *nl, struct nlmsghdr *msg)
{
    struct ifinfomsg *ifi=NLMSG_DATA(msg);
    //struct ifaddrmsg *ifa=NLMSG_DATA(msg);
    struct if_item_s *p;
    
    switch (msg->nlmsg_type)
    {
//         case RTM_NEWADDR:
// 	    p = ifs_set_item(ifa->ifa_index,-1);
//             printf("msg_handler: RTM_NEWADDR : %s\n",p->name);
//             break;
//         case RTM_DELADDR:
// 	    p = ifs_set_item(ifa->ifa_index,-1);
//             printf("msg_handler: RTM_DELADDR : %s\n",p->name);
//             break;
        case RTM_NEWLINK:
	    p = ifs_set_item(ifi->ifi_index, ifi->ifi_flags);
//printf("msg_handler: ifi_index=%d\n", ifi->ifi_index);
            //printf("msg_handler: RTM_NEWLINK (%s,%s)\n", p->name, ifi->ifi_flags & IFF_UP?"Up":"Down");
	    VPNMon_if_change(VPNMon_data,p);
            break;
        case RTM_DELLINK:
	    p = ifs_set_item(ifi->ifi_index, ifi->ifi_flags);
//printf("msg_handler: ifi_index=%d\n", ifi->ifi_index);
            //printf("msg_handler: RTM_DELLINK (%s,%s)\n", p->name, ifi->ifi_flags & IFF_UP?"Up":"Down");
	    VPNMon_if_change(VPNMon_data,p);
	    ifs_del_item(p);
            break;
        default:
            printf("msg_handler: Unknown netlink nlmsg_type %d\n",
                    msg->nlmsg_type);
            break;
    }
    return 0;
}

/**********************************************************************************************************************/

void *VPNMon_monthread(void *data)
{
    VPNMon_data_t *VPNMon_data = (VPNMon_data_t *)data;
    int status;
    int ret = 0;
    char buf[4096];
    struct iovec iov = { buf, sizeof buf };
    struct sockaddr_nl snl;
    struct msghdr msg = { (void*)&snl, sizeof snl, &iov, 1, NULL, 0, 0};
    struct nlmsghdr *h;

    //+TEST CODE
//     static int count=0;
//     char cIdBuf[4] = {'\0'};
    //-TEST CODE

    for (;;)
    {
	status = recvmsg(VPNMon_data->nls, &msg, 0*MSG_DONTWAIT);
//printf("read_netlink: recvmsg=%d\n", status);

	if (status < 0)
	{
//printf("read_netlink: errno=%d\n", errno);
	    /* Socket non-blocking so bail out once we have read everything */
	    if (errno == EWOULDBLOCK || errno == EAGAIN)
		break;
	    else
	    {
		/* Anything else is an error */
		printf("read_netlink: Error recvmsg: %d\n", status);
		perror("read_netlink: Error: ");
		break;
	    }
	}

	if (status == 0)
	{
	    printf("read_netlink: EOF\n");
	    break;
	}

	/* We need to handle more than one message per 'recvmsg' */
	for (h = (struct nlmsghdr *) buf; NLMSG_OK (h, (unsigned int)status); h = NLMSG_NEXT (h, status))
	{
	    /* Finish reading */
	    if (h->nlmsg_type == NLMSG_DONE)
		break;

	    /* Message is some kind of error */
	    if (h->nlmsg_type == NLMSG_ERROR)
	    {
		printf("read_netlink: Message is an error - decode TBD\n");
		break; // Error
	    }

	    /* Call message handler */
	    ret = VPNMon_msg_handler(VPNMon_data, &snl, h);
	    if (ret < 0)
	    {
		printf("read_netlink: Message hander error %d\n", ret);
	    }
	}
	

	//+TEST CODE
// 	count++;
// 	snprintf(cIdBuf, sizeof(cIdBuf), "a%d", count%100);
    
	//gtk_label_set_text((GtkLabel *)(VPNMon_data->pLabel),cIdBuf);
	//-TEST CODE
    }
    
    pthread_exit(NULL);
    return NULL;
}

static void VPNMon_destructor(gpointer user_data)
{
    VPNMon_data_t *VPNMon_data = (VPNMon_data_t *)user_data;

    pthread_cancel(VPNMon_data->monthreadid);
    pthread_join(VPNMon_data->monthreadid,NULL);
    
    close_netlink(VPNMon_data->nls);
    
    ifs_free();
    peers_free();
    
    //g_free(VPNMon_data->lock_pixbuf);
    //g_free(VPNMon_data->unlock_pixbuf);
    g_free(VPNMon_data);
}

GtkWidget *VPNMon_constructor(LXPanel *panel, config_setting_t *settings)
{
    VPNMon_data_t *VPNMon_data;
  
 /* panel is a pointer to the panel and
     settings is a pointer to the configuration data
     since we don't use it, we'll make sure it doesn't
     give us an error at compilation time */
    (void)panel;
    (void)settings;

	// allocate our private structure instance
	VPNMon_data = g_new0(VPNMon_data_t, 1);

	// update the instance count
	VPNMon_data->iMyId = ++iInstanceCount;

    // make a label out of the ID
    //char cIdBuf[10] = {'\0'};

    //snprintf(cIdBuf, sizeof(cIdBuf), "TP-%d", VPNMon_data->iMyId);

    VPNMon_data->lock_pixbuf = gdk_pixbuf_new_from_resource("/icons/lock.png",NULL);
    VPNMon_data->unlock_pixbuf = gdk_pixbuf_new_from_resource("/icons/unlock.png",NULL);
    VPNMon_static.vpn_up = if_up(VPN_IF_NAME);

    // create a label widget instance 
    //GtkWidget *pLabel = gtk_label_new(cIdBuf);
    //GtkWidget *pImage = gtk_image_new_from_stock(ICON_DOWN,GTK_ICON_SIZE_BUTTON);
    //GtkWidget *pImage = gtk_image_new_from_pixbuf(VPNMon_data->unlock_pixbuf);
    GtkWidget *pImage = gtk_image_new_from_pixbuf(VPNMon_static.vpn_up ? VPNMon_data->lock_pixbuf:VPNMon_data->unlock_pixbuf);

//g_free(pixbuf);
    
    // set the label to be visible
    //gtk_widget_show(pLabel);
    gtk_widget_show(pImage);

    // need to create a container to be able to set a border
    GtkWidget *p = gtk_event_box_new();

    // our widget doesn't have a window...
    // it is usually illegal to call gtk_widget_set_has_window() from application but for GtkEventBox it doesn't hurt
    gtk_widget_set_has_window(p, FALSE);

    // bind private structure to the widget assuming it should be freed using g_free()
    lxpanel_plugin_set_data(p, VPNMon_data, VPNMon_destructor);

    // set border width
    gtk_container_set_border_width(GTK_CONTAINER(p), 1);

    // add the label to the container
    //gtk_container_add(GTK_CONTAINER(p), pLabel);
    gtk_container_add(GTK_CONTAINER(p), pImage);

    // set the size we want
    gtk_widget_set_size_request(p, 40, 32);

    //VPNMon_data->pLabel = pLabel;
    VPNMon_data->pImage = pImage;
    
    //******************************//
    VPNMon_data->nls = open_netlink();
    peers_load();
    //******************************//


    pthread_create(&VPNMon_data->monthreadid, NULL, VPNMon_monthread, (void *)VPNMon_data);
//printf("VPNMon_constructor: monthreadid=%d\n",(int)(VPNMon_data->monthreadid));

    // success!!!
    return p;
}

/******************************************************************************/

void VPNMon_pon(GtkWidget *widget, gpointer data)
{
    char cmd[128];
 
    //(void)widget;
//printf("VPNMon_pon: %p,%p\n",widget,data); fflush(stdout);
//printf("VPNMon_pon: %c %c %c %c\n",*((char *)data),*((char *)data+1),*((char *)data+2),*((char *)data+3)); fflush(stdout);
//return;

    sprintf(cmd,"gksudo %s '%s' &",PON_CMD,(char *)data);
//printf("%s\n",cmd); fflush(stdout);
    system(cmd);
}

void VPNMon_poff()
{
    char cmd[128];

    sprintf(cmd,"gksudo '%s -a'",POFF_CMD);
    system(cmd);
}

/******************************************************************************/

static gboolean VPNMon_button_press(GtkWidget *widget, GdkEventButton *event, LXPanel *panel)
{
    GdkEventButton *event_button;
    int i;
    
    g_return_val_if_fail (event != NULL, FALSE);

//    if (event->type == GDK_BUTTON_PRESS) {
        event_button = (GdkEventButton *) event;
//printf("VPNMon_button_press: event_button=%d\n",event_button->button);
    if (event->type == GDK_BUTTON_PRESS && event_button->button == 1)
    {
	GtkWidget *menu;
	GtkWidget *menu_item;

	/* create menu */
	menu = gtk_menu_new();

	/* Peers */
	for (i=0; i<peers.count; i++)
	{
	    menu_item = gtk_menu_item_new_with_label(peers.item[i].name);
	    gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);
	    gtk_widget_set_sensitive(menu_item, !VPNMon_static.vpn_up);
//printf("VPNMon_button_press: %s,%p\n",peers.item[i].name,&peers.item[i]); fflush(stdout);
	    g_signal_connect(G_OBJECT(menu_item), "activate", G_CALLBACK(VPNMon_pon), &peers.item[i].name);
	}
	
	menu_item = gtk_separator_menu_item_new();
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);
	
	/* interface down */
	menu_item = gtk_menu_item_new_with_label("VPN Disconnect");
	gtk_widget_set_sensitive(menu_item, VPNMon_static.vpn_up);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);
	g_signal_connect(G_OBJECT(menu_item), "activate", G_CALLBACK(VPNMon_poff), NULL);

	gtk_widget_show_all(menu);

	gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, event_button->button, event_button->time);
	return TRUE;
    }
    return FALSE;
}

// typedef struct {
//     void (*init)(void);         /* optional startup */
//     void (*finalize)(void);     /* optional finalize */
//     char *name;                 /* name to represent in lists */
//     char *description;          /* tooltip text */
//     GtkWidget *(*new_instance)(LXPanel *panel, config_setting_t *settings);
//     GtkWidget *(*config)(LXPanel *panel, GtkWidget *instance);
//     void (*reconfigure)(LXPanel *panel, GtkWidget *instance);
//     gboolean (*button_press_event)(GtkWidget *widget, GdkEventButton *event, LXPanel *panel);
//     void (*show_system_menu)(GtkWidget *widget);
//     gboolean (*update_context_menu)(GtkWidget *plugin, GtkMenu *menu);
//     gboolean (*control)(GtkWidget *plugin, const char *cmd); /* not implemented */
//     int one_per_system : 1;     /* True to disable more than one instance */
//     int expand_available : 1;   /* True if "stretch" option is available */
//     int expand_default : 1;     /* True if "stretch" option is default */
//     int superseded : 1;         /* True if plugin was superseded by another */
// } LXPanelPluginInit;

/* Plugin descriptor. */
LXPanelPluginInit fm_module_init_lxpanel_gtk = {
   .name = "VPN Monitor",
   .description = "Run a VPN monitor",

   // assigning our functions to provided pointers.
   .new_instance = VPNMon_constructor,
   .button_press_event = VPNMon_button_press
};

FM_DEFINE_MODULE(lxpanel_gtk, vpnmon)

